/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.block.AdvancedBeehive;
import cy.jdkdigital.productivebees.common.block.DragonEggHive;
import cy.jdkdigital.productivebees.common.crafting.conditions.BeeExistsCondition;
import cy.jdkdigital.productivebees.common.crafting.conditions.FluidTagEmptyCondition;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBee;
import cy.jdkdigital.productivebees.dispenser.CageDispenseBehavior;
import cy.jdkdigital.productivebees.dispenser.ShearsDispenseItemBehavior;
import cy.jdkdigital.productivebees.event.EventHandler;
import cy.jdkdigital.productivebees.init.ModAdvancements;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModConfiguredFeatures;
import cy.jdkdigital.productivebees.init.ModContainerTypes;
import cy.jdkdigital.productivebees.init.ModEntities;
import cy.jdkdigital.productivebees.init.ModFeatures;
import cy.jdkdigital.productivebees.init.ModFluids;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModLootModifiers;
import cy.jdkdigital.productivebees.init.ModParticles;
import cy.jdkdigital.productivebees.init.ModPointOfInterestTypes;
import cy.jdkdigital.productivebees.init.ModProfessions;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import cy.jdkdigital.productivebees.init.ModTileEntityTypes;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredientFactory;
import cy.jdkdigital.productivebees.integrations.top.TopPlugin;
import cy.jdkdigital.productivebees.network.PacketHandler;
import cy.jdkdigital.productivebees.network.packets.Messages;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import cy.jdkdigital.productivebees.setup.ClientProxy;
import cy.jdkdigital.productivebees.setup.IProxy;
import cy.jdkdigital.productivebees.setup.ServerProxy;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ConditionContext;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.GameData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="productivebees")
@Mod.EventBusSubscriber(modid="productivebees")
public final class ProductiveBees {
    public static final String MODID = "productivebees";
    public static final Random rand = new Random();
    public static final IProxy proxy = (IProxy)DistExecutor.safeRunForDist(() -> ClientProxy::new, () -> ServerProxy::new);
    public static final Logger LOGGER = LogManager.getLogger();

    public ProductiveBees() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.addListener(this::onServerStarting);
        MinecraftForge.EVENT_BUS.addListener(this::onBiomeLoad);
        MinecraftForge.EVENT_BUS.addListener(this::onDataSync);
        MinecraftForge.EVENT_BUS.addListener(this::onEntityAttacked);
        MinecraftForge.EVENT_BUS.addListener(this::onEntityDeath);
        MinecraftForge.EVENT_BUS.addListener(this::onEntityHurt);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModPointOfInterestTypes.POI_TYPES.register(modEventBus);
        ModProfessions.PROFESSIONS.register(modEventBus);
        ModFluids.FLUIDS.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        ModBlocks.BLOCKS.register(modEventBus);
        ModEntities.HIVE_BEES.register(modEventBus);
        ModEntities.SOLITARY_BEES.register(modEventBus);
        ModEntities.ENTITIES.register(modEventBus);
        ModTileEntityTypes.BLOCK_ENTITIES.register(modEventBus);
        ModContainerTypes.CONTAINER_TYPES.register(modEventBus);
        ModFeatures.FEATURES.register(modEventBus);
        ModFeatures.TREE_DECORATORS.register(modEventBus);
        ModRecipeTypes.RECIPE_SERIALIZERS.register(modEventBus);
        ModParticles.PARTICLE_TYPES.register(modEventBus);
        ModLootModifiers.LOOT_SERIALIZERS.register(modEventBus);
        modEventBus.addListener(this::onInterModEnqueue);
        modEventBus.addGenericListener(Feature.class, this::onRegisterFeatures);
        modEventBus.addGenericListener(RecipeSerializer.class, this::onRegisterRecipeSerializer);
        modEventBus.addListener(this::onCommonSetup);
        modEventBus.addListener(EventHandler::onEntityAttributeCreate);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ProductiveBeesConfig.SERVER_CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ProductiveBeesConfig.CLIENT_CONFIG);
        CraftingHelper.register((IConditionSerializer)FluidTagEmptyCondition.Serializer.INSTANCE);
        CraftingHelper.register((IConditionSerializer)BeeExistsCondition.Serializer.INSTANCE);
        ForgeMod.enableMilkFluid();
    }

    public void onInterModEnqueue(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", TopPlugin::new);
    }

    public void onServerStarting(AddReloadListenerEvent event) {
        BeeReloadListener.INSTANCE.context = new ConditionContext(event.getServerResources().f_206849_);
        event.addListener((PreparableReloadListener)BeeReloadListener.INSTANCE);
    }

    private void onEntityAttacked(LivingAttackEvent event) {
        ConfigurableBee bee;
        Entity entity = event.getEntity();
        if (entity instanceof ConfigurableBee && (bee = (ConfigurableBee)entity).isIrradiated() && event.getSource().m_19385_().equals("mekanism.radiation")) {
            if (bee.breathCollectionCooldown < 0) {
                bee.breathCollectionCooldown = 600;
                bee.internalSetHasNectar(true);
            } else {
                bee.breathCollectionCooldown = (int)((float)bee.breathCollectionCooldown - event.getAmount());
            }
            event.setCanceled(true);
            bee.f_19853_.m_7605_((Entity)bee, (byte)2);
        }
    }

    private void onEntityDeath(LivingDeathEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ConfigurableBee) {
            ConfigurableBee bee = (ConfigurableBee)entity;
            if (event.getSource().m_19385_().equals("mekanism.radiation") && bee.getBeeType().equals("productivebees:radioactive") && (Double)ProductiveBeesConfig.BEES.deadBeeConvertChance.get() > event.getEntity().m_183503_().f_46441_.nextDouble() && BeeIngredientFactory.getIngredient("productivebees:wasted_radioactive").get() != null) {
                event.setCanceled(true);
                bee.m_21153_(bee.m_21233_());
                bee.setBeeType("productivebees:wasted_radioactive");
            }
        }
    }

    private void onEntityHurt(LivingHurtEvent event) {
        Entity damageSource = event.getSource().m_7639_();
        if (damageSource instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)damageSource;
            Entity entity = event.getEntity();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                boolean isWearingBeeHelmet = false;
                ItemStack itemstack = player.m_6844_(EquipmentSlot.HEAD);
                if (!itemstack.m_41619_() && itemstack.m_41720_().equals(ModItems.BEE_NEST_DIAMOND_HELMET.get())) {
                    isWearingBeeHelmet = true;
                }
                if (isWearingBeeHelmet && rand.nextDouble() < (Double)ProductiveBeesConfig.BEES.kamikazBeeChance.get()) {
                    Level level = player.m_183503_();
                    ConfigurableBee bee = (ConfigurableBee)((EntityType)ModEntities.CONFIGURABLE_BEE.get()).m_20615_(level);
                    BlockPos pos = player.m_142538_();
                    if (bee != null) {
                        bee.setBeeType("productivebees:kamikaz");
                        bee.setAttributes();
                        bee.m_6710_(attacker);
                        bee.m_7678_(pos.m_123341_(), (double)pos.m_123342_() + 0.5, pos.m_123343_(), bee.m_146908_(), bee.m_146909_());
                        level.m_7106_((ParticleOptions)ParticleTypes.f_123759_, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), 0.2, 0.1, 0.2);
                        level.m_5594_(player, pos, SoundEvents.f_11741_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                        level.m_7967_((Entity)bee);
                    }
                }
            }
        }
    }

    public void onRegisterFeatures(RegistryEvent.Register<Feature<?>> event) {
        ModConfiguredFeatures.registerConfiguredFeatures();
        ModConfiguredFeatures.registerPlacedFeatures();
    }

    public void onRegisterRecipeSerializer(RegistryEvent.Register<RecipeSerializer<?>> event) {
        ModRecipeTypes.registerTypes();
    }

    public void onCommonSetup(FMLCommonSetupEvent event) {
        PacketHandler.init();
        ModAdvancements.register();
        ModProfessions.register();
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ModItems.BEE_CAGE.get()), (DispenseItemBehavior)new CageDispenseBehavior());
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ModItems.STURDY_BEE_CAGE.get()), (DispenseItemBehavior)new CageDispenseBehavior());
        DispenserBlock.m_52672_((ItemLike)Items.f_42574_.m_5456_(), (DispenseItemBehavior)new ShearsDispenseItemBehavior());
        this.fixPOI(event);
    }

    private void onBiomeLoad(BiomeLoadingEvent event) {
        ModFeatures.registerFeatures(event);
    }

    private void onDataSync(OnDatapackSyncEvent event) {
        if (event.getPlayer() == null) {
            PacketHandler.sendToAllPlayers(new Messages.BeeDataMessage(BeeReloadListener.INSTANCE.getData()));
        } else {
            PacketHandler.sendBeeDataToPlayer(new Messages.BeeDataMessage(BeeReloadListener.INSTANCE.getData()), event.getPlayer());
        }
    }

    private void fixPOI(FMLCommonSetupEvent event) {
        PoiType.f_27348_.f_27325_ = this.makePOIStatesMutable(PoiType.f_27348_.f_27325_);
        ImmutableList beehives = (ImmutableList)ForgeRegistries.BLOCKS.getValues().stream().filter(block -> block instanceof AdvancedBeehive && !(block instanceof DragonEggHive)).collect(ImmutableList.toImmutableList());
        LOGGER.info("Adding modded beehives to vanilla beehive POI");
        for (Block block2 : beehives) {
            for (BlockState state : block2.m_49965_().m_61056_()) {
                GameData.getBlockStatePointOfInterestTypeMap().put(state, PoiType.f_27348_);
                try {
                    PoiType.f_27348_.f_27325_.add(state);
                }
                catch (Exception e) {
                    LOGGER.warn("Could not add blockstate to beehive POI " + state);
                }
            }
        }
        PoiType.f_27348_.f_27326_ = 1;
    }

    private Set<BlockState> makePOIStatesMutable(Set<BlockState> toCopy) {
        HashSet copy = Sets.newHashSet();
        copy.addAll(toCopy);
        return copy;
    }
}

